 ; Ŀ
 ;   Bungee - save the status of all layers for later restoration.         
 ;   Copyright 1997, 1998, 2004, 2006, 2008 by Rocket Software Ltd.        
 ;   Contains Bungee, which saves the current layer settings to a list     
 ;            and to a .ddl file named after the drawing.                  
 ;            Splash, which restores the layer settings from the list.     
 ;            Flash, which restores them from the (or any) .ddl file and   
 ;            which treats xref names in layer names as wild cards.        
 ;            Flasho, which restores them from the (or any) .ddl file      
 ;            and which uses layer names exactly as they are.              
 ;            Layup, which sets up layers based on settings in the file    
 ;            Layers.txt if a copy is found in the directory containing    
 ;            the current drawing.                                         
 ;                                                                         
 ;   Anything in a layer data file after a semicolon or in a box is a      
 ;   comment and is ignored.                                               
 ;   Note: you can't turn every layer in a drawing off, and modifying a    
 ;   .ddl file to do so is probably a bad idea.                            
 ;                                                                         
 ;   If the dinosaurs hadn't become extinct, we'd probably have to spend   
 ;   most of our time cleaning up huge piles of shed skin.                 
 ; 

 ; Ŀ
 ;   Bliss - restore the previous state of layers.                         
 ;   Takes one argument, a layer data list (the desired layer states).     
 ; 
 (DEFUN BLISS (laylst / num sub suba dslist lala exlist exsub clam clbase
                                            frizp lockp offp col tmplay tmpsub)
 ; Ŀ
 ;   Make the list of layers from the desired state list with non-xref     
 ;   base names: ((base full_name other_stuff) ...)                        
 ;   Come to think of it, the full name may not be that useful, so ditch   
 ;   it: ((base_name other_stuff) ...)                                     
 ; 
  (setq num 0)
  (while (setq sub (nth num laylst))
         (setq num (1+ num))
         (setq suba (labas (car sub)))
         (setq sub (append (list (car suba)) (cdr sub)))
         (setq dslist (cons sub dslist)))
 ; Ŀ
 ;   Make the list of existing layers with non-xref                        
 ;   base names: ((base full_name) ...)                                    
 ; 
  (setq lala (lager))
  (setq num 0)
  (while (setq sub (nth num lala))
         (setq num (1+ num))
         (setq suba (labas sub))
         (setq sub (list (car suba) sub))
         (setq exlist (cons sub exlist)))
 ; Ŀ
 ;   Step through the layers.                                              
 ; 
  (setq num 0)
  (command "layer")
  (while (setq exsub (nth num exlist))
         (setq num (1+ num))
         (grtext -2 (setq clam (cadr exsub)))
         (setq clbase (car exsub))
 ; Ŀ
 ;   Get the base layer name and the matching sublist from lala.           
 ; 
         (if (setq sub (assoc clbase dslist))
             (progn
                  (setq frizp (nth 1 sub))
                  (setq lockp (nth 2 sub))
                  (setq offp (nth 3 sub))
 ; Ŀ
 ;   Make sure that the colour number wasn't negative, which it will be    
 ;   if the layer was off, the layer command will reject this and crash    
 ;   the program.                                                          
 ; 
                  (setq col (nth 4 sub))
                  (cond ((and (= (type col) 'INT) (minusp col))
                         (setq col (itoa (abs col))))
                        ((= (type col) 'INT)
                         (setq col (itoa col))))
 ; Ŀ
 ;   Freeze or Thaw the layer.                                             
 ; 
                  (cond ((null frizp)
                         (command "thaw" clam))
 ; Ŀ
 ;   Trying to freeze the current layer will cause an error and the        
 ;   routine will crash.  If the layer about to be frozen is current then  
 ;   call Thonk to find another thawed one to make current.                
 ; 
                        ((= (getvar "clayer") clam)
                         (setq tmplay (thonk))
                         (setvar "clayer" tmplay)
 ; Ŀ
 ;   See if the new current layer should be locked and lock it if so.      
 ;   (Making it current quietly unlocks it.)                               
 ; 
                         (if (nth 2 (setq tmpsub
                                        (assoc (car (labas tmplay)) dslist)))
                             (command "lock" tmplay))
 ; Ŀ
 ;   And turn it off or on depending in the setting in the list dslist.    
 ;   But wait: making a layer current turns it on, which is ok since this  
 ;   saves having to see if it is off or on, but turning the current       
 ;   layer off requires a confirmation.                                    
 ; 
                         (if (nth 3 tmpsub)
                             (progn
                                  (command "Off" tmplay)
                                  (command "y")))
 ; Ŀ
 ;   Freeze the original layer being dealt with.                           
 ; 
                         (command "freeze" clam))
                        (t
                         (command "freeze" clam)))
 ; Ŀ
 ;   Lock or unlock the layer as required.                                 
 ; 
                  (if lockp (command "lock" clam) (command "unlock" clam))
 ; Ŀ
 ;   Must set the colour before turning the layer off, since setting a     
 ;   layer colour turns the layer on.                                      
 ; 
                  (if col (command "colour" col clam))
 ; Ŀ
 ;   Turning the current layer off requires a "y" for confirmation.        
 ; 
                  (if offp
                      (progn
                           (command "off" clam)
                           (if (= (getvar "clayer") clam)
                               (command "y")))
                      (command "on" clam)))))
  (command "")
 (princ))
 ; Ŀ
 ;   Bliss end.                                                            
 ; 

 ; Ŀ
 ;   Blisso - restore the previous state of layers.                        
 ;   Takes one argument, a layer data list.                                
 ;   This is the original version which doesn't allow for different        
 ;   xref names in layers - names are used axactly as they are.            
 ; 
 (DEFUN BLISSO (laylst / num clam sub frizp lockp offp col tmplay)
 ; Ŀ
 ;   Step through the layers and the layer status list laylst.             
 ; 
  (setq num 0)
  (command "layer")
  (while (setq sub (nth num laylst))
         (setq num (1+ num))
         (grtext -2 (setq clam (car sub)))
 ; Ŀ
 ;   Make sure the layer exists.                                           
 ;   The Layer command: M = make and set current, N = new but not current. 
 ; 
         (if (null (tblsearch "layer" clam))
             (command "n" clam))
         (setq frizp (nth 1 sub))
         (setq lockp (nth 2 sub))
         (setq offp (nth 3 sub))
 ; Ŀ
 ;   Make sure that the colour number wasn't negative, which it will be    
 ;   if the layer was off, the layer command will reject this and crash    
 ;   the program.                                                          
 ; 
         (setq col (nth 4 sub))
         (cond ((and (= (type col) 'INT) (minusp col))
                (setq col (itoa (abs col))))
               ((= (type col) 'INT)
                (setq col (itoa col))))
 ; Ŀ
 ;   Freeze or Thaw the layer.                                             
 ; 
         (cond ((null frizp)
                (command "thaw" clam))
 ; Ŀ
 ;   Trying to freeze the current layer will cause an error and the        
 ;   routine will crash.  If the layer about to be frozen is current then  
 ;   call Thonk to find another thawed one to make current.                
 ; 
               ((= (getvar "clayer") clam)
                (setq tmplay (thonk))
                (setvar "clayer" tmplay)
 ; Ŀ
 ;   See if the new current layer should be locked and lock it if so.      
 ;   (Making it current quietly unlocks it.)                               
 ; 
                (if (nth 2 (assoc tmplay laylst))
                    (command "lock" tmplay))
 ; Ŀ
 ;   And turn it off or on depending in the setting in the list Laylst.    
 ;   But wait: making a layer current turns it on, which is ok since this  
 ;   saves having to see if it is off or on, but turning the current       
 ;   layer off requires a confirmation.                                    
 ; 
                (if (nth 3 (assoc tmplay laylst))
                    (progn
                         (command "Off" tmplay)
                         (command "y")))
 ; Ŀ
 ;   Freeze the original layer being dealt with.                           
 ; 
                (command "freeze" clam))
               (t
                (command "freeze" clam)))
 ; Ŀ
 ;   Lock or unlock the layer as required.                                 
 ; 
         (if lockp (command "lock" clam) (command "unlock" clam))
 ; Ŀ
 ;   Must set the colour before turning the layer off, since setting a     
 ;   layer colour turns the layer on.                                      
 ; 
         (if col (command "colour" col clam))
 ; Ŀ
 ;   Turning the current layer off requires a "y" for confirmation.        
 ; 
         (if offp
             (progn
                  (command "off" clam)
                  (if (= (getvar "clayer") clam)
                      (command "y")))
             (command "on" clam)))
  (command "")
 (princ))
 ; Ŀ
 ;   Blisso end.                                                           
 ; 

 ; Ŀ
 ;   Bottle - write a boxed file header.                                   
 ;   Takes no prisoners, returns nothing.                                  
 ;   Correction - takes one argument, a filename.                          
 ;   Further correction - takes another argument, list of strings to       
 ;   write, each on its own line.                                          
 ; 
 (DEFUN BOTTLE (lognam strlst / aa bb cc thestr newlst lognam fn)
  (setq aa "")
  (setq bb (strcat " " aa aa ""))
  (setq cc (strcat " " aa aa ""))
  (while (setq thestr (car strlst))
         (setq strlst (cdr strlst))
         (setq thestr (strcat "   " thestr))
         (while (< (strlen thestr) 76) (setq thestr (strcat thestr " ")))
         (setq thestr (strcat thestr ""))
         (setq newlst (append newlst (list thestr))))
  (setq fn (open lognam "w"))
  (princ bb fn)
  (while (setq thestr (car newlst))
         (setq newlst (cdr newlst))
         (princ (strcat "\n" thestr) fn))
  (princ (strcat "\n" cc) fn)
  (close fn))
 ; Ŀ
 ;   Bottle end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Flash - restore the previous state of layers.              
 ;   Reads layer settings from a Dwgname.ddl data file or if that isn't    
 ;   available can use any ddl file...which may or may not be right.       
 ;   Arguments: Subnam, the subroutine to call:                            
 ;                Bliss treats xref names in layer names as wild cards.    
 ;                Blisso treats layer names as being exact.                
 ; 
 (DEFUN FLASH (subnam / *error* filnam fillst)
  (setvar "cmdecho" 0)
  (defun *error* (shk)
   (print shk)
  (princ))
 ; Ŀ
 ;   Make a directory path and name string without the extension.          
 ; 
  (setq filnam (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (= (substr (strcase filnam t) (- (setq len (strlen filnam)) 3)) ".dwg")
      (setq filnam (substr filnam 1 (- len 4))))
  (setq filnam (findfile (strcat filnam ".ddl")))
;  (if (null filnam) (setq filnam ""))
  (if (null filnam) (setq filnam (getvar "dwgprefix")))
  (if (setq filnam (getfiled "Layer Data File" filnam "ddl" 6))
      (progn
           (if (setq fillst (fst filnam))
               (subnam fillst)
               (write-line "* Abort: no status list in file *")))
      (write-line "File not available."))
 (princ))
 ; Ŀ
 ;   Subroutine Flash end.                                                 
 ; 

 ; Ŀ
 ;   Fst - read a line from a file (a list written to a file with print)   
 ;   and make it back into a list.                                         
 ;   The list is made with Relish, which returns a list, so the full       
 ;   list:file:list cycle adds one more layer of listing, thus caadr must  
 ;   be used on the result: cadr to extract the list from the (now empty)  
 ;   string and list list, and car to remove the outer list.               
 ;   Modified: the file now consists of multiple lines, each containing    
 ;   one list, and a header.  Also want to allow for comments.             
 ; 
 (DEFUN FST (filnam / fn str num esav lla)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq str (read-line fn))
                  (while (and (/= (substr str 1 1) "")
                              (= (substr str 1 1) " "))
                         (setq str (substr str 2)))
                  (if (null (member (substr str 1 1) (list ";" "" "" "")))
                      (setq lla (append lla (cadr (relish str))))))
           (close fn))
      (setq lla ()))
 lla)
 ; Ŀ
 ;   Fst end.                                                              
 ; 

 ; Ŀ
 ;   Isxlay - see if a layer belongs to an xref - i.e. if the name         
 ;   passed as the sole argument contains a |.                             
 ;   Returns T if so, otherwise nil.                                       
 ; 
 (DEFUN ISXLAY (str / pos sub foundx)
  (setq pos 1)
  (while (and (null foundx) (setq sub (substr str pos 1)) (/= sub ""))
         (if (= sub "|")
             (setq foundx t)
             (setq pos (1+ pos))))
 foundx)
 ; Ŀ
 ;   Isxlay end.                                                           
 ; 

 ; Ŀ
 ;   Labas - remove xref data from a layer name.                           
 ;   Takes one argument, a layer name string.                              
 ;   Returns a list of the base layer name and the original name.          
 ; 
 (DEFUN LABAS (lanam / lala lalis)
  (cond ((setq lala (sos lanam))
         (setq lalis (list lala lanam)))
        ((not (equal (setq lala (splat "|" lanam)) (list lanam)))
         (setq lalis (list (cadr lala) lanam)))
        (t
         (setq lalis (list lanam lanam))))
 lalis)
 ; Ŀ
 ;   Labas end.                                                            
 ; 

 ; Ŀ
 ;   Lager: returns a list of all layer names.                             
 ;   Listens to no arguments, returns a list.                              
 ; 
 (DEFUN LAGER (/ rew llist lala)
  (setq rew t)
  (while (setq llist (tblnext "layer" rew))
         (setq rew ())
         (setq lala (cons (cdr (assoc 2 llist)) lala)))
 (reverse lala))
 ; Ŀ
 ;   Lager end (sad).                                                      
 ; 

 ; Ŀ
 ;   Relish - make a text string into a list.                              
 ;   Takes one argument, a string.                                         
 ;   Returns the remainder of the string and a list.                       
 ; 
 (DEFUN RELISH (str / stop achar nulst curvar)
  (setq curvar "")
  (while (and (null stop) (> (strlen str) 0))
         (setq achar (substr str 1 1))
         (setq str (substr str 2))
         (cond ((= achar "(")
                (setq strand (relish str))
                (setq nulst (append nulst (list (cadr strand))))
                (setq str (car strand)))
               ((= achar ")")
                (while (= (substr str 1 1) " ")
                       (setq str (substr str 2)))
                 (setq stop t))
               ((= achar " ")
                (setq curvar (read curvar))
                (setq nulst (append nulst (list curvar)))
                (setq curvar ""))
               ((= achar "\"")
                (if (not (member curvar '("" " ")))
                    (progn
                         (setq curvar (read curvar))
                         (setq nulst (append nulst (list curvar)))
                         (setq curvar "")))
                (while (and (setq achar (substr str 1 1))
                            (setq str (substr str 2))
                            (/= achar "")
                            (/= achar "\""))
                       (if (/= achar "\"")
                           (setq curvar (strcat curvar achar))))
                (setq nulst (append nulst (list curvar)))
                (setq str (substr str 2))
                (setq curvar ""))
               (t
                (setq curvar (strcat curvar achar)))))
  (if (/= curvar "") 
      (setq nulst (append nulst (list (read curvar)))))
 (list str nulst))
 ; Ŀ
 ;   Relish end.                                                           
 ; 

 ; Ŀ
 ;   Slog - returns a text string chosen at random from a list.            
 ;   Takes no arguments, returns a string.                                 
 ; 
 (DEFUN SLOG (/ s nnum mlst)
  (setq s (* (getvar "cdate") 10000000.0))
  (setq mlst (list
  "Chicken Beak Macaroni - love it or leave it."
  "The US military is still quietly working on the Nerf ICBM."
  "Thermonuclear indoor fireworks: an idea whose time is yet to come."
  "Modern dentistry is rendering diesel powered false teeth obsolete."
  "Caseless ammunition, draft beer - is there really any difference?"
  "Cell phones still don't come with a free \"Dork\" tattoo."
  "The fall of railroads: due to the lack of an all-terrain locomotive."
  "If our drawings were really detailed, we wouldn't need text."
  "Fortunately for the army there is no shocking pink terrain."
  "There are no Escher drawing in which anyone is smiling."))
  (setq nnum (fix (* 10 (- s ( fix s)))))
 (nth nnum mlst))
 ; Ŀ
 ;   Slog end.                                                             
 ; 

 ; Ŀ
 ;   SOS - return a string split at the substring $n$ (n = any sequence    
 ;   of numerals.)  If the sequence isn't found, returns ().               
 ; 
 (DEFUN SOS (magnus / pos1 pos2 stop found$ cha)
  (setq pos1 1)               ; position of first $
  (setq pos2 1)               ; current position $
  (setq stop ())              ; stop flag
  (setq found$ ())            ; first $ located flag
 ; Ŀ
 ;   While the stop flag isn't set and there is a character at             
 ;   the current position.                                                 
 ; 
  (while (and (null stop)
              (setq cha (substr magnus pos2 1)))
 ; Ŀ
 ;   Cond: if haven't found the first $ yet, do so.                        
 ; 
         (cond ((null found$)
                (while (and (setq cha (substr magnus pos1 1))
                            (/= cha "")
                            (/= cha "$"))
                       (setq pos1 (1+ pos1)))
                (if (= cha "$")
                    (progn
                         (setq found$ T)
                         (setq pos2 (1+ pos1)))
                    (setq stop T)))
 ; Ŀ
 ;   Cond: if have found a second $ then stop.                             
 ; 
               ((and (= cha "$")
                     (> pos2 (1+ pos1)))
                (setq stop "ok"))
 ; Ŀ
 ;   Cond: second $ but without intervening space, so count as first $.    
 ; 
               ((= cha "$")
                (setq pos1 pos2)
                (setq pos2 (1+ pos2)))
 ; Ŀ
 ;   Cond: an integer.  Continue.                                          
 ; 
               ((= (type (read cha)) 'INT)
                (setq pos2 (1+ pos2)))
 ; Ŀ
 ;   Cond: neither an $ nor an integer.  The last $ must not have been     
 ;   the marker, so set Found$ to nil and start looking again.             
 ; 
               (T
                  (setq pos2 (1+ pos2))
                  (setq pos1 pos2)
                  (setq found$ ()))))
 ; Ŀ
 ;   Cond and While end.                                                   
 ;   If the $n$ sequence was found, return everything after it, else ().   
 ; 
  (if (= stop "ok")
      (substr magnus (1+ pos2))))
 ; Ŀ
 ;   Sos end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
 strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Thonk: returns the name of the first thawed layer which isn't an      
 ;   xref layer.  (One can't freeze the current layer or make an xref      
 ;   layer current, so there must be one.)                                 
 ;   Listens to no arguments, returns a layer name.                        
 ; 
 (DEFUN THONK (/ rew llist lanam sev frizp layon)
  (setq rew t)
  (while (and (null layon) (setq llist (tblnext "layer" rew)))
         (setq rew ())
         (setq lanam (cdr (assoc 2 llist)))
         (setq sev (cdr (assoc 70 llist)))
         (setq frizp (if (= (logand sev 1) 1) t ()))
         (if (and (null frizp) (null (isxlay lanam)))
             (setq layon lanam)))
 layon)
 ; Ŀ
 ;   Thonk end.                                                            
 ; 

 ; Ŀ
 ;   Bungee - saves the current state of layers to the global list Allst   
 ;   and to a file: Dwgname.ddl.                                           
 ; 
 (DEFUN C:BUNGEE (/ llist rew lanam sev col frizp lockp offp statls)
  (setvar "cmdecho" 0)
  (setq allst ())
  (setq rew t)
  (while (setq llist (tblnext "layer" rew))
         (setq rew ())
         (setq lanam (cdr (assoc 2 llist)))
         (setq sev (cdr (assoc 70 llist)))
         (setq col (cdr (assoc 62 llist)))
         (setq frizp (if (= (logand sev 1) 1) t ()))
         (setq lockp (if (= (logand sev 4) 4) t ()))
         (setq offp (if (minusp (cdr (assoc 62 llist))) t ()))
         (setq statls (list lanam frizp lockp offp col))
         (setq allst (append allst (list statls))))
 ; Ŀ
 ;   Make a directory path and name string without the extension.          
 ; 
  (setq filnam (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (= (substr (strcase filnam t) (- (setq len (strlen filnam)) 3)) ".dwg")
      (setq filnam (substr filnam 1 (- len 4))))
  (setq filnam (strcat filnam ".ddl"))
  (setq tlis (list (strcat "Layer setting data for "
                           (itoa (length allst)) " layers in "
                           (getvar "dwgname") ".")
                   "This file was created by Bungee.lsp."
                   ""
                   "Line format: (\"Layername\" Freeze/Thaw Lock/Unlock Off/On Colour)"
                   "T = Frozen/Locked/Off, nil = Thawed/Unlocked/On."
                   ""
                   (slog)))
  (bottle filnam tlis)
  (setq fn (open filnam "a"))
  (setq num 0)
  (while (setq sub (nth num allst))
         (print sub fn)
         (setq num (1+ num)))
  (close fn)
 (princ))
 ; Ŀ
 ;   C:Bungee end.                                                         
 ; 

 ; Ŀ
 ;   Flash - restore the previous state of layers.                         
 ;   Treats xref names in layer names as being wild cards.                 
 ;   Reads layer settings from a Dwgname.ddl data file or if that isn't    
 ;   available can use any ddl file...which may or may not be right.       
 ; 
 (DEFUN C:FLASH ()
  (setvar "cmdecho" 0)
  (flash bliss)
 (princ))
 ; Ŀ
 ;   C:Flash end.                                                          
 ; 

 ; Ŀ
 ;   Flasho - restore the previous state of layers.                        
 ;   Treats layer names from files as being exact strings.                 
 ;   Reads layer settings from a Dwgname.ddl data file or if that isn't    
 ;   available can use any ddl file...which may or may not be right.       
 ; 
 (DEFUN C:FLASHO ()
  (setvar "cmdecho" 0)
  (flash blisso)
 (princ))
 ; Ŀ
 ;   C:Flasho end.                                                         
 ; 

 ; Ŀ
 ;   Layup - set the layer state from the file Layers.txt if it is         
 ;   found in the directory with the current drawing.                      
 ;   Treats xref names in layer names as being wild cards.                 
 ; 
 (DEFUN C:LAYUP (/ *error* fnam fillst)
  (setvar "cmdecho" 0)
  (defun *error* (shk)
   (print shk)
  (princ))
 ; Ŀ
 ;   Get the list of layer states from the config file Layers.txt.         
 ; 
  (if (setq fnam (findfile (strcat (getvar "dwgprefix") "layers.txt")))
      (progn
 ; Ŀ
 ;   Indicate which Layers.txt file was used.                              
 ; 
           (prompt (strcat "\nUsing Layer data File: " fnam))
 ; Ŀ
 ;   And update the layers if the data is available.                       
 ; 
           (if (setq fillst (fst fnam))
               (bliss fillst)
               (write-line "* Abort: no status list in file *"))))
 (princ))
 ; Ŀ
 ;   C:Layup end.                                                          
 ; 

 ; Ŀ
 ;   Splash. - restore the previous state of layers.                       
 ;   Grabs layer settings from the global data list Allst.                 
 ; 
 (DEFUN C:SPLASH ()
  (setvar "cmdecho" 0)
  (if allst
     (bliss allst)
     (write-line "No status list: run Bungee to make or Flash to read from a file."))
 (princ))
 ; Ŀ
 ;   C:Splash end.                                                         
 ; 

(prompt "C:BUNGEE/C:/LAYUP/C:SPLASH/C:FLASH/C:FLASHO")
(princ)
